//%attributes = {}
// Method: _io_ ExportImportXml 
// 13.05.09, 00:17:02 / PM
// © Copyright Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_TEXT:C284($0; $1; $2; $_io_result; $_io_job; $_io_textpara)
C_POINTER:C301($3; $_io_blobpara)  // mulitpurpose parameter, also used for pointer on field
C_LONGINT:C283($4; $_io_longintpara)

C_BOOLEAN:C305(_io_fExportImportStop)  // this is the only global variable

If (False:C215)
	// Generic Export/Import of whole database as XML files
	// handles automatically all field types, including blobs or subtables
	// command must be called BEFORE Set Field Titles is used - else only fields from that list, specially for subtables, are used...
	
	//call it as:
	// _info_ ALERT (_io_ ExportImportXml ("Import";""))
	// or
	// _info_ ALERT (_io_ ExportImportXml ("Import";"C:\\myxmlfolder"))
	// or similar to export:
	// _info_ ALERT (_io_ ExportImportXml ("Export";""))
	
	// IMPORTANT: 
	// A) Logfile:
	//  specially for large databases you should disable 4D's logfile (for backup integration)
	// before you start importing. Else all operations are written to the logfile, which makes import slower
	// if you include this method for your customer into your application, you can check using the command Log File if a log file is used.
	// don't forget to alert the user to enable the logfile (run a full backup + create logfile) after reimport is completed!
	
	// b) Trigger:
	// if you are using Triggers to modify the content on saving a record (like time stamp or counter)
	// you must disable them during the import
	// this can be done by temporarly modifying your source code or by using a variable as a flag
	
	// c) subtables:
	//  a subtable field must not have the same name than the subtable itself!
	
	//  XML documents are named with the table name, field names are used for XML Tags
	// invalid character in table/field names are replaced by "_", also leading numbers (like [table]3field)
	// this may lead to non unique field names. To avoid that it is possible to use table/field numbers as identifiers
	// to enable that call the routine like:
	//  _info_ ALERT (_io_ ExportImportXml ("Import";"C:\\myxmlfolder";->OK;1))  ` use 0 for names, 1 for numbers - similar for Export
	//  parameter 3 is an unused pointer to any existing variable, you may use the system variable OK
	// note: using table/field names allow a reorganization of the structure. A new build structure with different table/field order
	// can be used to reimport, because field names are used as identifiers. 
	// even XML Files can be on XP larger than 2 GB this produces problems on Mac OS X, so created xml files are segmented to stay smaller than 2 GB
	
	// copy into Compiler_xxx method to allow compilations with all variables are typed:
	//C_TEXT(_io_ ExportImportXml ;$0;$1;$2)
	//C_POINTER(_io_ ExportImportXml ;$3)
	//C_LONGINT(_io_ ExportImportXml ;$4)
	//C_BOOLEAN(_io_fExportImportStop)  ` this is the only project variable, to allow an external stop through a dialog/Even call
	
	// written by Thomas Maul, 4D Germany, January 2006. to be used with 4D 2004.3 or newer
	// note: it can be used starting with 2004.1, but large databases (SAX commands) can lead to a memory leak, fixed in 2004.3.
	//  history:
	//  2006-03-06: text fields may be after conversation > 32k,  now use blobs to read/write text fields
	//  2007-01-18: errors with Subfields found /corrected by Peter Grün, thanks
	//  2007-03-07: changed encoding to UTF-8, was ISO-8859-1, to keep some MacRoman chars
	
	// $_io_result:=_io_ ExportImportXml("job";$_io_textpara;$_io_blobparapointer;$_io_longintpara)
End if 


C_BLOB:C604($_io_internalrecord; $_io_SaveIndex; $_io_blob)
C_TIME:C306($_io_ref)
C_LONGINT:C283($_io_tablenr; $_io_fieldnr; $_io_tableID; $_io_length; $_io_reccounter; $_io_vlchar; $_io_newseqnumber; $_io_loop; $_io_loopfields; $_io_subloop)
C_LONGINT:C283($_io_pos; $_io_pos2; $_io_index; $_io_i; $_io_fieldlength; $_io_vlsystem; $_io_fieldtyp; $_io_vlascii; $_io_total; $_io_vlplatform; $_io_vlmachine)
C_LONGINT:C283($_io_findpos; $_io_myevent; $_io_subtablefield; $_io_tablecount; $_io_count; $_io_maxloop; $_io_table; $_io_xmllevel; $_io_segment)
C_PICTURE:C286($_io_pict; $_io_pictvariable)
C_POINTER:C301($_io_tableptr; $_io_tbl; $_io_subfieldptr; $_io_field; $_io_fieldptr; $_io_Table_Pointer)
C_TEXT:C284($_io_result2; $_io_name; $_io_Filename; $_io_vname; $_io_vprefix; $_io_t; $_io_t2; $_io_vschar; $_io_value; $_io_dummytext; $_io_message; $_io_dirsymbol)
C_TEXT:C284($_io_subtablename; $_io_return)
_O_C_STRING:C293(2; $_io_directory)
C_BOOLEAN:C305($_io_isIndex; $_io_readwrite)

C_LONGINT:C283($_io_MaxExportSize)
$_io_MaxExportSize:=1500*1024*1024  // size in Megabyte - used to segment created XML files

If (Count parameters:C259<1)  // usefull for testing in user mode
	_info_ CONFIRM_SET_OK("Export or Import?\nWARNING: Import deletes all existing records!"; "Export"; "Import")
	If (OK=1)
		$_io_job:="Export"
	Else 
		$_io_job:="Import"
	End if 
Else 
	$_io_job:=$1
End if 

$_io_result:=""
If (Count parameters:C259>1)
	$_io_textpara:=$2
Else 
	$_io_textpara:=""
End if 
If (Count parameters:C259>2)
	$_io_blobpara:=$3
Else 
	$_io_blobpara:=->$_io_internalrecord
End if 
If (Count parameters:C259>3)
	$_io_longintpara:=$4
Else 
	$_io_longintpara:=0
End if 


Case of 
	: ($_io_job="Export")  //  **********************************  EXPORT ***********************************************
		$_io_result:="Export successfull"
		If ($_io_textpara="")
			$_io_textpara:=Select folder:C670("Select Targetfolder")
		End if 
		If ($_io_textpara#"")
			$_io_dirSymbol:=_io_ ExportImportXml("DirSymbol")
			If ($_io_textpara=("@"+$_io_dirSymbol))
				$_io_textpara:=Substring:C12($_io_textpara; 1; Length:C16($_io_textpara)-1)
			End if 
			$_io_ref:=Test path name:C476($_io_textpara)
			If ($_io_ref=0)
				_io_fExportImportStop:=False:C215
				$_io_tablecount:=Get last table number:C254
				For ($_io_i; 1; $_io_tablecount)
					If (Not:C34(_io_fExportImportStop))
						If ($_io_longintpara=1)
							$_io_name:="Table_"+String:C10($_io_i)
						Else 
							$_io_name:=_io_ ExportImportXml("ReplaceChar"; Table name:C256($_io_i); $_io_blobpara; 1)
						End if 
						$_io_segment:=1
						$_io_filename:=$_io_textpara+$_io_dirSymbol+$_io_name+".xml"
						If (Test path name:C476($_io_filename)>0)
							DELETE DOCUMENT:C159($_io_filename)
						End if 
						$_io_ref:=Create document:C266($_io_filename)
						$_io_tbl:=Table:C252($_io_i)
						SAX SET XML DECLARATION:C858($_io_ref; "UTF-8"; True:C214)
						$_io_NewSeqNumber:=Get database parameter:C643($_io_tbl->; Table sequence number:K37:31)
						SAX OPEN XML ELEMENT:C853($_io_ref; "Table_"+$_io_name; "Sequenceno"; String:C10($_io_NewSeqNumber); "Total"; String:C10(Records in table:C83($_io_tbl->)))
						$_io_readWrite:=(_tbl WriteState($_io_i)=kFalse)  //Read only state($_io_tbl->)
						READ ONLY:C145($_io_tbl->)
						ALL RECORDS:C47($_io_tbl->)
						$_io_maxloop:=Records in selection:C76($_io_tbl->)
						For ($_io_loop; 1; $_io_maxloop)
							If (($_io_loop%100)=1)
								$_io_message:=Table name:C256($_io_i)+" ("+String:C10($_io_i)+"/"+String:C10($_io_tablecount)+")"+": "+String:C10($_io_loop)+" / "+String:C10($_io_maxloop)
								_io_ ExportImportXml("Message"; $_io_message)
								If (Get document position:C481($_io_ref)>$_io_MaxExportSize)  //  create a new segment
									$_io_segment:=$_io_segment+1
									CLOSE DOCUMENT:C267($_io_ref)
									$_io_filename:=$_io_textpara+$_io_dirSymbol+$_io_name+"-"+String:C10($_io_segment)+".xml"
									If (Test path name:C476($_io_filename)>0)
										DELETE DOCUMENT:C159($_io_filename)
									End if 
									$_io_ref:=Create document:C266($_io_filename)
									$_io_tbl:=Table:C252($_io_i)
									SAX SET XML DECLARATION:C858($_io_ref; "UTF-8"; True:C214)
									SAX OPEN XML ELEMENT:C853($_io_ref; "Table_"+$_io_name; "Total"; String:C10(Records in table:C83($_io_tbl->)))
								End if 
							End if 
							SAX OPEN XML ELEMENT:C853($_io_ref; "T_"+$_io_name)
							// now loop through all fields
							For ($_io_loopfields; 1; Get last field number:C255($_io_tbl))
								$_io_fieldptr:=Field:C253($_io_i; $_io_loopfields)
								If ($_io_longintpara=1)
									$_io_vname:="F_"+String:C10($_io_loopfields)
									$_io_result2:=_io_ ExportImportXml("ExportField"; $_io_vname; $_io_fieldptr; $_io_ref+0)
								Else 
									$_io_result2:=_io_ ExportImportXml("ExportField"; ""; $_io_fieldptr; $_io_ref+0)
								End if 
								If ($_io_result2#"")
									_io_fExportImportStop:=True:C214
									$_io_result:=$_io_result2
								End if 
								If (_io_fExportImportStop)
									$_io_loopfields:=Get last field number:C255($_io_tbl)+1
								End if 
							End for 
							SAX CLOSE XML ELEMENT:C854($_io_ref)
							If (Process aborted:C672)
								_io_fExportImportStop:=True:C214
							End if 
							If (_io_fExportImportStop)
								$_io_loop:=$_io_maxloop+1
							End if 
							NEXT RECORD:C51($_io_tbl->)
						End for 
						SAX CLOSE XML ELEMENT:C854($_io_ref)
						REDUCE SELECTION:C351($_io_tbl->; 0)
						If (Not:C34($_io_readWrite))
							READ WRITE:C146($_io_tbl->)
						End if 
						CLOSE DOCUMENT:C267($_io_ref)
					End if 
					If (_io_fExportImportStop)
						$_io_i:=Get last table number:C254+1
					End if 
				End for 
			Else 
				$_io_result:="_io_ ExportImportXml: Wrong call -Target path for export is not a valid path to a folder"
			End if 
		End if 
		
		
	: ($_io_job="Import")  //  **********************************  IMPORT ***********************************************
		$_io_result:="Import successfull"
		If ($_io_textpara="")
			$_io_textpara:=Select folder:C670("Select Folder with XML Export")
		End if 
		If ($_io_textpara#"")
			$_io_dirSymbol:=_io_ ExportImportXml("DirSymbol")
			If ($_io_textpara=("@"+$_io_dirSymbol))
				$_io_textpara:=Substring:C12($_io_textpara; 1; Length:C16($_io_textpara)-1)
			End if 
			$_io_ref:=Test path name:C476($_io_textpara)
			If ($_io_ref=0)
				_io_fExportImportStop:=False:C215
				For ($_io_table; 1; Get last table number:C254)
					If (Not:C34(_io_fExportImportStop))
						If ($_io_longintpara=1)
							$_io_name:="Table_"+String:C10($_io_i)
						Else 
							$_io_name:=_io_ ExportImportXml("ReplaceChar"; Table name:C256($_io_table); $_io_blobpara; 1)
						End if 
						$_io_filename:=$_io_textpara+$_io_dirSymbol+$_io_name+".xml"
						If (Test path name:C476($_io_filename)=1)
							SET BLOB SIZE:C606($_io_SaveIndex; 0)
							_io_ ExportImportXml("GetAllIndex"; ""; ->$_io_SaveIndex; $_io_table)
							_io_ ExportImportXml("SetIndex"; "Clear"; ->$_io_SaveIndex; $_io_table)
							$_io_Table_Pointer:=Table:C252($_io_table)
							//$_io_readWrite:=Read only state($_io_Table_Pointer->)
							$_io_readWrite:=(_tbl WriteState($_io_table)=kFalse)
							READ WRITE:C146($_io_Table_Pointer->)
							$_io_maxloop:=Get last field number:C255($_io_Table_Pointer)
							_O_ARRAY STRING:C218(32; $_io_fieldnames; $_io_maxloop)
							ALL RECORDS:C47($_io_Table_Pointer->)
							DELETE SELECTION:C66($_io_Table_Pointer->)
							$_io_Reccounter:=1
							For ($_io_loopfields; 1; $_io_maxloop)
								If ($_io_longintpara=1)
									$_io_fieldnames{$_io_loopfields}:="F_"+String:C10($_io_loopfields)  //  2007-01-18
								Else 
									$_io_fieldnames{$_io_loopfields}:=_io_ ExportImportXml("ReplaceChar"; Field name:C257($_io_table; $_io_loopfields); $_io_blobpara; 1)
								End if 
							End for 
							$_io_xmllevel:=0
							$_io_total:=0
							$_io_segment:=1
							
							Repeat 
								If ($_io_segment>1)  // only for additional segments - large XML files
									$_io_filename:=$_io_textpara+$_io_dirSymbol+$_io_name+"-"+String:C10($_io_segment)+".xml"
								End if 
								If (Test path name:C476($_io_filename)=1)
									$_io_ref:=Open document:C264($_io_filename; "TEXT"; Read mode:K24:5)
									Repeat 
										$_io_MyEvent:=SAX Get XML node:C860($_io_ref)
										Case of 
											: ($_io_MyEvent=XML start document:K45:7)
												// nothing?
											: ($_io_MyEvent=XML start element:K45:10)
												SAX GET XML ELEMENT:C876($_io_ref; $_io_vName; $_io_vPrefix; $_io_attrName; $_io_attrvalue)
												Case of 
													: ($_io_xmllevel=0)  // start of XML file, main level
														If ($_io_vName#("table_"+$_io_name))
															$_io_result:="Wrong main content "+$_io_vName+" - Table_"+$_io_name
															_io_fExportImportStop:=True:C214
														Else 
															$_io_xmllevel:=1
															$_io_NewSeqNumber:=0
															$_io_findpos:=Find in array:C230($_io_attrName; "Sequenceno")
															If ($_io_findpos>0)
																$_io_NewSeqNumber:=Num:C11($_io_attrvalue{$_io_findpos})
															End if 
															$_io_findpos:=Find in array:C230($_io_attrName; "Total")
															If ($_io_findpos>0)
																$_io_total:=Num:C11($_io_attrvalue{$_io_findpos})
															End if 
														End if 
													: ($_io_xmllevel=1)  // start of new record, check table name
														If ($_io_vName#("T_"+$_io_name))
															$_io_result:="Wrong table name "+$_io_vName+" T_"+$_io_name
															_io_fExportImportStop:=True:C214
														Else 
															$_io_xmllevel:=2
															CREATE RECORD:C68($_io_Table_Pointer->)
															$_io_Reccounter:=$_io_Reccounter+1
															If (($_io_Reccounter%100)=1)
																$_io_message:=Table name:C256($_io_table)+" "+String:C10($_io_Reccounter)+" / "+String:C10($_io_total)
																_io_ ExportImportXml("Message"; $_io_message)
																//If (($_io_Reccounter%1000)=1)  `  this slows down the import drastically for huge databases
																//FLUSH BUFFERS  ` best to use a cache of 500 MB and let 4D handle the flushing
																//End if 
															End if 
														End if 
														
													: ($_io_xmllevel>=2)  // subtable?
														If ($_io_vName="Sub_@")
															$_io_subtablename:=Substring:C12($_io_vName; 5)  // remove "Sub_"
															$_io_loopfields:=Find in array:C230($_io_fieldnames; $_io_subtablename)
															If ($_io_loopfields>0)
																// create array subtables ...
																$_io_fieldptr:=Field:C253($_io_table; $_io_loopfields)
																GET FIELD TITLES:C804($_io_fieldptr->; $_io_subnames; $_io_subid)
																If ($_io_longintpara=1)  // use field numbers
																	For ($_io_i; 1; Size of array:C274($_io_subnames))
																		$_io_subnames{$_io_i}:="Sub_"+String:C10($_io_i)
																	End for 
																End if 
																_O_CREATE SUBRECORD:C72($_io_fieldptr->)
																$_io_subtablefield:=$_io_loopfields
															End if 
														End if 
														$_io_xmllevel:=$_io_xmllevel+1
												End case   // $_io_MyEvent=XML Start Element 
												
											: ($_io_MyEvent=XML CDATA:K45:13)
												If ($_io_xmllevel=3)
													$_io_loopfields:=Find in array:C230($_io_fieldnames; $_io_vName)
													If ($_io_loopfields>0)
														SAX GET XML CDATA:C878($_io_ref; $_io_blob)
														If (OK=1)
															BASE64 DECODE:C896($_io_blob)
															$_io_fieldptr:=Field:C253($_io_table; $_io_loopfields)
															$_io_Fieldtyp:=Type:C295($_io_fieldptr->)
															Case of 
																: ($_io_Fieldtyp=Is BLOB:K8:12)
																	$_io_fieldptr->:=$_io_blob
																	SET BLOB SIZE:C606($_io_blob; 0)
																: ($_io_Fieldtyp=Is picture:K8:10)
																	BLOB TO VARIABLE:C533($_io_blob; $_io_pictVariable)
																	SET BLOB SIZE:C606($_io_blob; 0)  // to free up memory
																	$_io_fieldptr->:=$_io_pictVariable
															End case 
														End if 
													End if 
												End if 
												
											: ($_io_MyEvent=XML DATA:K45:12)
												Case of 
													: ($_io_xmllevel=3)
														// Name of element is already in $_io_vName
														$_io_loopfields:=Find in array:C230($_io_fieldnames; $_io_vName)
														If ($_io_loopfields>0)
															// known field, get field value and assign
															$_io_result2:=_io_ ExportImportXml("ImportField"; $_io_value; Field:C253($_io_table; $_io_loopfields); $_io_ref+0)
															If ($_io_result2#"")
																_io_fExportImportStop:=True:C214
																$_io_result:=$_io_result2
															End if 
														End if 
														
													: ($_io_xmllevel=4)  // subtable
														// Name of element is already in $_io_vName
														$_io_loopfields:=Find in array:C230($_io_subnames; $_io_vName)
														If ($_io_loopfields>0)
															// known field, get field value and assign
															//  SAX GET XML ELEMENT VALUE($_io_ref;$_io_value)  ` line removed, 2007-1-18
															$_io_subfieldptr:=Field:C253($_io_table; $_io_subtablefield; $_io_subid{$_io_loopfields})
															$_io_result2:=_io_ ExportImportXml("ImportField"; $_io_value; $_io_subfieldptr; $_io_ref+0)
															If ($_io_result2#"")
																_io_fExportImportStop:=True:C214
																$_io_result:=$_io_result2
															End if 
														End if 
												End case 
												
											: ($_io_MyEvent=XML end element:K45:11)
												$_io_xmllevel:=$_io_xmllevel-1
												Case of 
													: ($_io_xmllevel=1)
														SAVE RECORD:C53($_io_Table_Pointer->)
													: ($_io_xmllevel=0)  // table ready
														If ($_io_NewSeqNumber#0)
															SET DATABASE PARAMETER:C642($_io_Table_Pointer->; Table sequence number:K37:31; $_io_NewSeqNumber)
														End if 
												End case 
										End case 
										If (Process aborted:C672)
											_io_fExportImportStop:=True:C214
										End if 
									Until (($_io_MyEvent=XML end document:K45:15) | (_io_fExportImportStop))
									CLOSE DOCUMENT:C267($_io_ref)
									$_io_segment:=$_io_segment+1
								Else   // last segment used - but still data missing!
									_info_ ALERT("Import for table "+Table name:C256($_io_table)+"uncompleted!\n"+String:C10($_io_Reccounter)+" of "+String:C10($_io_total)+" imported.")
								End if 
							Until (($_io_Reccounter>=$_io_Total) | (_io_fExportImportStop))
							
							REDUCE SELECTION:C351($_io_Table_Pointer->; 0)
							_io_ ExportImportXml("SetIndex"; "Set"; ->$_io_SaveIndex; $_io_table)
							If (Not:C34($_io_readWrite))
								READ WRITE:C146($_io_Table_Pointer->)
							End if 
							
							If (Process aborted:C672)
								_io_fExportImportStop:=True:C214
							End if 
							If (_io_fExportImportStop)
								$_io_loop:=$_io_maxloop+1
							End if 
						End if 
					End if 
					If (_io_fExportImportStop)
						$_io_table:=Get last table number:C254+1  //  2007-18-1
					End if 
				End for 
			Else 
				$_io_result:="_io_ ExportImportXml: Wrong call -Target path for export is not a valid path to a folder"
			End if 
		End if 
		
		
		//  **********************************  INTERNAL CALLS - NOT FOR DIRECT USAGE ***********************************************
		
	: ($_io_job="ImportField")  //  **********************************  ImportField ***********************************************
		$_io_fieldptr:=$_io_blobpara
		$_io_ref:=?00:00:00?+$_io_longintpara
		$_io_Fieldtyp:=Type:C295($_io_fieldptr->)
		
		If ($_io_fieldtyp=Is text:K8:3)
			SAX GET XML ELEMENT VALUE:C877($_io_ref; $_io_blob)
			$_io_textpara:=BLOB to text:C555($_io_blob; Mac text without length:K22:10)
		Else 
			SAX GET XML ELEMENT VALUE:C877($_io_ref; $_io_textpara)
		End if 
		
		If ($_io_fieldtyp#Is subtable:K8:11)
			Case of 
				: ($_io_fieldtyp=Is alpha field:K8:1)
					GET FIELD PROPERTIES:C258($_io_fieldptr; $_io_fieldtyp; $_io_Fieldlength)
					If ($_io_Fieldlength=0)  // subfield, checking is not possible, as long as export is unmodified it will work perfect
						$_io_fieldptr->:=$_io_textpara  // may need character conversation, depends on ACI0043259
						//   $_io_fieldptr->:=_io_ ExportImportXml ("ReplaceCharBack";$_io_textpara;$_io_blobpara;0)
					Else 
						$_io_fieldptr->:=Substring:C12($_io_textpara; 1; $_io_Fieldlength)
						// may need character conversation, depends on ACI0043259
					End if 
				: ($_io_fieldtyp=Is text:K8:3)
					// $_io_fieldptr->:=_io_ ExportImportXml ("ReplaceCharBackBlob";"";->$_io_blob;0) ` may need character conversation, depends on ACI0043259
					$_io_fieldptr->:=$_io_textpara
				: (($_io_fieldtyp=Is integer:K8:5) | ($_io_fieldtyp=Is longint:K8:6))
					$_io_fieldptr->:=Num:C11($_io_textpara)
				: ($_io_fieldtyp=Is real:K8:4)
					If (String:C10(12)="1,2")  // system use comma, not point
						$_io_textpara:=Replace string:C233($_io_textpara; "."; ",")
					End if 
					$_io_fieldptr->:=Num:C11($_io_textpara)
				: (($_io_fieldtyp=Is date:K8:7))
					$_io_fieldptr->:=Date:C102($_io_textpara)
				: (($_io_fieldtyp=Is time:K8:8))
					$_io_fieldptr->:=Time:C179($_io_textpara)
				: (($_io_fieldtyp=Is boolean:K8:9))
					$_io_fieldptr->:=(Num:C11($_io_textpara)=1)
				: (($_io_fieldtyp=Is BLOB:K8:12) | ($_io_fieldtyp=Is picture:K8:10))
					If ($_io_textpara#"")
						$_io_result:="_io_ ExportImportXml: Internal Error, found Blob without CData"+Field name:C257($_io_fieldptr)
					End if 
			End case 
		Else   //subtable, oops
			$_io_result:="_io_ ExportImportXml: Internal Error, found Subtable "+Field name:C257($_io_fieldptr)
		End if 
		
		
	: ($_io_job="ExportField")  //  **********************************  ExportField ***********************************************
		$_io_fieldptr:=$_io_blobpara
		$_io_ref:=?00:00:00?+$_io_longintpara
		// check the type to convert the content
		//  GET FIELD PROPERTIES($_io_fieldptr;$_io_Fieldtyp)
		$_io_Fieldtyp:=Type:C295($_io_fieldptr->)
		If ($_io_textpara#"")
			$_io_name:=_io_ ExportImportXml("ReplaceChar"; $_io_textpara; $_io_blobpara; 1)
		Else 
			$_io_name:=_io_ ExportImportXml("ReplaceChar"; Field name:C257($_io_fieldptr); $_io_blobpara; 1)
		End if 
		If ($_io_fieldtyp#Is subtable:K8:11)
			If (_io_ ExportImportXml("CheckFieldEmpty"; ""; $_io_fieldptr; $_io_Fieldtyp)="0")
				SAX OPEN XML ELEMENT:C853($_io_ref; $_io_name)
				Case of 
					: ($_io_fieldtyp=Is alpha field:K8:1)
						// conversation maybe not needed, depends on ACI0043259
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; _io_ ExportImportXml("ReplaceChar"; $_io_fieldptr->; $_io_blobpara; 0))
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: ($_io_fieldtyp=Is text:K8:3)
						// conversation maybe not needed, depends on ACI0043259
						SET BLOB SIZE:C606($_io_blob; 0)
						// Text may be >32k after conversation
						$_io_dummytext:=_io_ ExportImportXml("ReplaceCharBlob"; $_io_fieldptr->; ->$_io_blob; 0)
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; $_io_blob)
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: ($_io_fieldtyp=Is real:K8:4)
						$_io_dummytext:=String:C10($_io_fieldptr->)
						$_io_dummytext:=Replace string:C233($_io_dummytext; ","; ".")  // needed if used on a system with decimal comma
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; $_io_dummytext)
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: (($_io_fieldtyp=Is integer:K8:5) | ($_io_fieldtyp=Is longint:K8:6))
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; String:C10($_io_fieldptr->))
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: (($_io_fieldtyp=Is date:K8:7))
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; String:C10($_io_fieldptr->; 8))  // XML Date format
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: (($_io_fieldtyp=Is time:K8:8))
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; String:C10($_io_fieldptr->; 8))  // XML Date format
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: (($_io_fieldtyp=Is boolean:K8:9))
						SAX ADD XML ELEMENT VALUE:C855($_io_ref; String:C10(Num:C11($_io_fieldptr->)))
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: ($_io_fieldtyp=Is BLOB:K8:12)
						$_io_blob:=$_io_fieldptr->
						If (BLOB size:C605($_io_blob)#0)
							BASE64 ENCODE:C895($_io_blob)
							SAX ADD XML CDATA:C856($_io_ref; $_io_blob)
						End if 
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					: ($_io_fieldtyp=Is picture:K8:10)
						$_io_pict:=$_io_fieldptr->
						VARIABLE TO BLOB:C532($_io_pict; $_io_blob)
						If (BLOB size:C605($_io_blob)#0)
							BASE64 ENCODE:C895($_io_blob)
							SAX ADD XML CDATA:C856($_io_ref; $_io_blob)
						End if 
						SAX CLOSE XML ELEMENT:C854($_io_ref)
					Else 
						$_io_result:="_io_ ExportImportXml: Internal Error - Unkown Fieldtyp - cannot handle "+Field name:C257($_io_fieldptr)
				End case 
			End if 
		Else   //subtable, oops
			_O_ALL SUBRECORDS:C109($_io_fieldptr->)
			ARRAY TEXT:C222($_io_subnames; 0)
			ARRAY LONGINT:C221($_io_subid; 0)
			GET FIELD TITLES:C804($_io_fieldptr->; $_io_subnames; $_io_subid)
			If ($_io_textpara#"")  //  2007-01-18
				For ($_io_i; 1; Size of array:C274($_io_subnames))
					$_io_subnames{$_io_i}:="Sub_"+String:C10($_io_i)
				End for 
			End if 
			$_io_tablenr:=Table:C252($_io_fieldptr)
			$_io_fieldnr:=Field:C253($_io_fieldptr)
			While (Not:C34(_O_End subselection:C37($_io_fieldptr->)))
				SAX OPEN XML ELEMENT:C853($_io_ref; "Sub_"+$_io_name)
				For ($_io_subloop; 1; Size of array:C274($_io_subnames))
					$_io_subfieldptr:=Field:C253($_io_tablenr; $_io_fieldnr; $_io_subid{$_io_subloop})
					$_io_result:=_io_ ExportImportXml("ExportField"; $_io_subnames{$_io_subloop}; $_io_subfieldptr; $_io_ref+0)
					If ($_io_result#"")
						_io_fExportImportStop:=True:C214
					End if 
				End for 
				SAX CLOSE XML ELEMENT:C854($_io_ref)
				If (Process aborted:C672)
					_io_fExportImportStop:=True:C214
				End if 
				If (_io_fExportImportStop)
					_O_LAST SUBRECORD:C201($_io_fieldptr->)
				End if 
				_O_NEXT SUBRECORD:C62($_io_fieldptr->)
			End while 
		End if 
		
		
	: ($_io_job="CheckFieldEmpty")  //  **********************************  CheckFieldEmpty ***********************************************
		$_io_result:="0"
		$_io_fieldtyp:=$_io_longintpara
		$_io_fieldptr:=$_io_blobpara
		Case of 
			: (($_io_fieldtyp=Is alpha field:K8:1) | ($_io_fieldtyp=Is text:K8:3))
				If ($_io_fieldptr->="")
					$_io_result:="1"
				End if 
			: (($_io_fieldtyp=Is real:K8:4) | ($_io_fieldtyp=Is integer:K8:5) | ($_io_fieldtyp=Is longint:K8:6))
				If ($_io_fieldptr->=0)
					$_io_result:="1"
				End if 
			: (($_io_fieldtyp=Is date:K8:7))
				If ($_io_fieldptr->=!00-00-00!)
					$_io_result:="1"
				End if 
			: (($_io_fieldtyp=Is time:K8:8))
				If ($_io_fieldptr->=?00:00:00?)
					$_io_result:="1"
				End if 
			: (($_io_fieldtyp=Is boolean:K8:9))
				// nothing
			: ($_io_fieldtyp=Is BLOB:K8:12)
				If (BLOB size:C605($_io_fieldptr->)=0)
					$_io_result:="1"
				End if 
			: ($_io_fieldtyp=Is picture:K8:10)
				If (Picture size:C356($_io_fieldptr->)=0)
					$_io_result:="1"
				End if 
		End case 
		
	: ($_io_job="Message")  //  **********************************  Message ***********************************************
		MESSAGE:C88($_io_textpara)
		
	: ($_io_job="DirSymbol")  //  **********************************  DirSymbol ***********************************************
		_O_PLATFORM PROPERTIES:C365($_io_vlPlatform; $_io_vlSystem; $_io_vlMachine)
		If ($_io_vlPlatform=Windows:K25:3)
			$_io_Directory:="\\"
		Else 
			$_io_Directory:=":"
		End if 
		$_io_result:=$_io_Directory
		
	: ($_io_job="ReplaceChar")  //  **********************************  ReplaceChar ***********************************************
		$_io_t:=$_io_textpara
		If ($_io_longintpara#0)  //  remove
			$_io_return:=""
			If (Length:C16($_io_t)>0)
				$_io_vlAscii:=Character code:C91($_io_t[[1]])
				If (($_io_vlAscii>=48) & ($_io_vlAscii<=58))
					$_io_return:="_"
				End if 
			End if 
			For ($_io_vlChar; 1; Length:C16($_io_t))
				$_io_vlAscii:=Character code:C91($_io_t[[$_io_vlChar]])
				Case of 
					: (($_io_vlAscii>=127) | ($_io_vlAscii<=31))
						$_io_vsChar:="_"
					: (Position:C15(Char:C90($_io_vlAscii); ":<>&%=' ()[]{}"+Char:C90(34))>0)
						$_io_vsChar:="_"
					Else 
						$_io_vsChar:=Char:C90($_io_vlAscii)
				End case 
				$_io_return:=$_io_return+$_io_vsChar
			End for 
		Else 
			$_io_return:=""
			For ($_io_vlChar; 1; Length:C16($_io_t))
				$_io_vsChar:=$_io_t[[$_io_vlChar]]
				Case of 
					: (Position:C15($_io_vsChar; "<>&\r\n\t")>0)  //  &#9;
						$_io_return:=$_io_return+"&#"+String:C10((Character code:C91($_io_vsChar)))+";"
					: (Character code:C91($_io_vsChar)<32)
						// filter char!!!
					: (Character code:C91($_io_vsChar)>127)  //  &#9;
						//  $_io_return:=$_io_return+"&#"+String((Ascii($_io_vsChar)))+";"
						$_io_return:=$_io_return+$_io_vsChar
					Else 
						$_io_return:=$_io_return+$_io_vsChar
				End case 
			End for 
		End if 
		$_io_result:=$_io_return
		
	: ($_io_job="ReplaceCharBlob")  //  **********************************  ReplaceCharBlob ***********************************************
		// similar to ReplaceChar, but expects data in text and returns in blob, for returned text > 32k
		$_io_t:=$_io_textpara
		$_io_return:=""
		For ($_io_vlChar; 1; Length:C16($_io_t))
			$_io_vsChar:=$_io_t[[$_io_vlChar]]
			Case of 
				: (Position:C15($_io_vsChar; "<>&\r\n\t")>0)  //  &#9;
					$_io_return:=$_io_return+"&#"+String:C10((Character code:C91($_io_vsChar)))+";"
				: (Character code:C91($_io_vsChar)<32)
					// filter char!!!
				: (Character code:C91($_io_vsChar)>127)  //  &#9;
					$_io_return:=$_io_return+$_io_vsChar
				Else 
					$_io_return:=$_io_return+$_io_vsChar
			End case 
			If (Length:C16($_io_return)>30000)
				TEXT TO BLOB:C554($_io_return; $_io_blobpara->; Mac text without length:K22:10; *)
				$_io_return:=""
			End if 
		End for 
		TEXT TO BLOB:C554($_io_return; $_io_blobpara->; Mac text without length:K22:10; *)
		$_io_result:=""
		
	: ($_io_job="ReplaceCharBack")  //  **********************************  ReplaceCharBack ***********************************************
		$_io_result:=$_io_textpara
		$_io_pos2:=0
		Repeat 
			If ($_io_pos2>0)
				$_io_result2:=Substring:C12($_io_result; $_io_pos2)
			Else 
				$_io_result2:=$_io_result
			End if 
			$_io_pos:=Position:C15("&#"; $_io_result2)
			If ($_io_pos>0)
				$_io_pos:=$_io_pos+$_io_pos2
				$_io_t2:=Substring:C12($_io_result; $_io_pos)
				$_io_pos2:=Position:C15(";"; $_io_t2)
				$_io_t2:=Substring:C12($_io_t2; 1; $_io_pos2)
				$_io_vsChar:=Substring:C12($_io_t2; 3; Length:C16($_io_t2)-3)
				$_io_vlAscii:=Num:C11($_io_vsChar)
				$_io_result:=Replace string:C233($_io_result; $_io_t2; Char:C90($_io_vlAscii))
				$_io_pos2:=$_io_pos+1
			End if 
		Until ($_io_pos<1)
		$_io_result:=Replace string:C233($_io_result; "&lt;"; "<")
		$_io_result:=Replace string:C233($_io_result; "&gt;"; ">")
		$_io_result:=Replace string:C233($_io_result; "&amp;"; "&")
		
	: ($_io_job="ReplaceCharBackBlob")  //  **********************************  ReplaceCharBackBlob ***********************************************
		// simular to ReplaceCharBack, expects blob, returns text, for text > 32k
		$_io_result:=""
		$_io_offset:=0
		$_io_textpara:=BLOB to text:C555($_io_blobpara->; Mac text without length:K22:10; $_io_offset; 32000)
		While ($_io_textpara#"")
			$_io_result:=$_io_result+_io_ ExportImportXml("ReplaceCharBack"; $_io_textpara; $_io_blobpara; 0)
			$_io_textpara:=BLOB to text:C555($_io_blobpara->; Mac text without length:K22:10; $_io_offset; 32000)
		End while 
		$_io_result:=_io_ ExportImportXml("ReplaceCharBack"; $_io_result; $_io_blobpara; 0)  // again for full result - if a &# combination was in between  two pieces
		
	: ($_io_job="GetAllIndex")  //  **********************************  GetAllIndex ***********************************************
		// returns Blob (Boolean) Area with all index fields for the table $_io_longintpara in $_io_blobpara (Pointer expected)
		$_io_tableptr:=Table:C252($_io_longintpara)
		$_io_count:=Get last field number:C255($_io_tableptr)
		ARRAY BOOLEAN:C223($_io_indexfields; $_io_count)
		For ($_io_loop; 1; Get last field number:C255($_io_tableptr))
			GET FIELD PROPERTIES:C258(Table:C252($_io_tableptr); $_io_loop; $_io_fieldtyp; $_io_length; $_io_IsIndex)
			$_io_indexfields{$_io_loop}:=$_io_IsIndex
		End for 
		VARIABLE TO BLOB:C532($_io_indexfields; $_io_blobpara->)
		
	: ($_io_job="SetIndex")  //  **********************************  SetIndex ***********************************************
		// uses Blob (Boolean) Area with all index fields for the table $_io_longintpara from $_io_blobpara (Pointer expected)
		//  $_io_textpara="set" or "clear"
		$_io_TablePtr:=Table:C252($_io_longintpara)
		ARRAY BOOLEAN:C223($_io_Indexfields; 0)
		BLOB TO VARIABLE:C533($_io_blobpara->; $_io_Indexfields)
		For ($_io_index; 1; Size of array:C274($_io_indexfields))
			If ($_io_indexfields{$_io_index})
				$_io_field:=Field:C253(Table:C252($_io_tableptr); $_io_index)
				If ($_io_textpara="set")
					SET INDEX:C344($_io_field->; True:C214; 50)
				Else 
					SET INDEX:C344($_io_field->; False:C215; 50)
				End if 
			End if 
		End for 
		
	Else 
		$_io_result:="_io_ ExportImportXml: Wrong call - invalid job ID"
End case 

If (Count parameters:C259<1)  // debug, call from user mode or design mode
	_info_ ALERT($_io_result)
Else 
	$0:=$_io_result
End if 
